-- Oracle8i DDL
-- create table script

set echo on

----------
-- create data tables

-- uniques

create table uniques (
u_key	int	not null,
u_int	int	not null,
u_signed	int null,
u_float	float(4)	not null,
u_double	float(8)	not null,
u_decim	numeric (18,4)	not null,
u_date	date	not null,
u_code	char(10)	not null,
u_name	char(20)	not null,
u_address	varchar(80)	not null
) parallel;

-- hundred

create table hundred (
h_key	int	not null,
h_int	int	not null,
h_signed	int null,
h_float	float(4)	not null,
h_double	float(8)	not null,
h_decim	numeric (18,4)	not null,
h_date	date	not null,
h_code	char(10)	not null,
h_name	char(20)	not null,
h_address	varchar(80)	not null
) parallel;

-- tenpct

create table tenpct (
t_key	int	not null,
t_int	int	not null,
t_signed	int null,
t_float	float(4)	not null,
t_double	float(8)	not null,
t_decim	numeric (18,4)	not null,
t_date	date	not null,
t_code	char(10)	not null,
t_name	char(20)	not null,
t_address	varchar(80)	not null
) parallel;

-- updates

create table updates (
p_key	int	not null,
p_int	int	not null,
p_signed	int null,
p_float	float(4)	not null,
p_double	float(8)	not null,
p_decim	numeric (18,4)	not null,
p_date	date	not null,
p_code	char(10)	not null,
p_name	char(20)	not null,
p_address	varchar(80)	not null
) parallel;

-------------------------

-- tenthou

create table tenthou (
t_key	int	not null,
t_int	int	not null,
t_signed	int null,
t_float	float(4)	not null,
t_double	float(8)	not null,
t_decim	numeric (18,4)	not null,
t_date	date	not null,
t_code	char(10)	not null,
t_name	char(20)	not null,
t_address	varchar(80)	not null
) parallel;

-- hunthou

create table hunthou (
h_key	int	not null,
h_int	int	not null,
h_signed	int null,
h_float	float(4)	not null,
h_double	float(8)	not null,
h_decim	numeric (18,4)	not null,
h_date	date	not null,
h_code	char(10)	not null,
h_name	char(20)	not null,
h_address	varchar(80)	not null
) parallel;

-- twomill

create table twomill (
p_key	int	not null,
p_int	int	not null,
p_signed	int null,
p_float	float(4)	not null,
p_double	float(8)	not null,
p_decim	numeric (18,4)	not null,
p_date	date	not null,
p_code	char(10)	not null,
p_name	char(20)	not null,
p_address	varchar(80)	not null
) parallel;

-- threemill

create table threemill (
t_key	int	not null,
t_int	int	not null,
t_signed	int null,
t_float	float(4)	not null,
t_double	float(8)	not null,
t_decim	numeric (18,4)	not null,
t_date	date	not null,
t_code	char(10)	not null,
t_name	char(20)	not null,
t_address	varchar(80)	not null
) parallel;

-- fourmill

create table fourmill (
t_key	int	not null,
t_int	int	not null,
t_signed	int null,
t_float	float(4)	not null,
t_double	float(8)	not null,
t_decim	numeric (18,4)	not null,
t_date	date	not null,
t_code	char(10)	not null,
t_name	char(20)	not null,
t_address	varchar(80)	not null
) parallel;

-- fivemill

create table fivemill (
h_key	int	not null,
h_int	int	not null,
h_signed	int null,
h_float	float(4)	not null,
h_double	float(8)	not null,
h_decim	numeric (18,4)	not null,
h_date	date	not null,
h_code	char(10)	not null,
h_name	char(20)	not null,
h_address	varchar(80)	not null
) parallel;

-- fourram

create table fourram (
p_key	int	not null,
p_int	int	not null,
p_signed	int null,
p_float	float(4)	not null,
p_double	float(8)	not null,
p_decim	numeric (18,4)	not null,
p_date	date	not null,
p_code	char(10)	not null,
p_name	char(20)	not null,
p_address	varchar(80)	not null
) parallel;

-- reportview

create view reportview (r_key, r_signed, r_date, r_decim, r_name, r_code, r_int) as
	select updates.p_key, updates.p_signed, updates.p_date, updates.p_decim, hundred.h_name, hundred.h_code, hundred.h_int
	from updates, hundred
		where updates.p_key = hundred.h_key;

----------
-- create housekeeping tables

-- update_int_history

create table update_int_history (
p_key	int	not null,
p_int	int not null,
p_date date not null
) parallel;

-- oltp_write_01_check_value
create table oltp_write_01_check_value (
int_sum float not null
) parallel;

-- update_signed_history

create table update_signed_history (
p_key	int	not null,
p_signed	int not null,
p_date date not null
) parallel;

-- del_history

create table del_history (
h_key	int	not null,
h_int	int	not null,
h_signed	int null,
h_float	float(4)	not null,
h_double	float(8)	not null,
h_decim	numeric (18,4)	not null,
h_date	date	not null,
h_code	char(10)	not null,
h_name	char(20)	not null,
h_address	varchar(80)	not null
) parallel;

-- oltp_write_04_count_updates
create table oltp_write_04_count_updates (
num_updates int not null
) parallel;

-- end
commit;
exit;
